(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5617,        213]*)
(*NotebookOutlinePosition[      6520,        243]*)
(*  CellTagsIndexPosition[      6476,        239]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Linear Independence\nof Solutions of\nCauchy-Euler Equations"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Normally x!=0 and in the complex case, b!=0. These are just examples."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Distinct Roots"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[a, b, c, x]\), "\n", 
    \(Ker = {x\^a, x\^b, x\^c}\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({x\^a, x\^b, x\^c}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      w = Table[\[PartialD]\_{x, i}Ker, {i, 0, Length[Ker] - 1}]]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(x\^a\), \(x\^b\), \(x\^c\)},
            {\(a\ x\^\(\(-1\) + a\)\), \(b\ x\^\(\(-1\) + b\)\), \(c\ \
x\^\(\(-1\) + c\)\)},
            {\(\((\(-1\) + a)\)\ a\ x\^\(\(-2\) + a\)\), \(\((\(-1\) + 
                    b)\)\ b\ x\^\(\(-2\) + b\)\), \(\((\(-1\) + 
                    c)\)\ c\ x\^\(\(-2\) + c\)\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[Det[w]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\((a - b)\)\)\ \((a - c)\)\ \((b - 
          c)\)\ x\^\(\(-3\) + a + b + c\)\)], "Output"]
}, Closed]],

Cell[TextData[
"This is nonero as long as a, b, and c are all different."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Repeated Roots"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[a]\), "\n", 
    \(Ker = x\^a\ {1, Log[x], Log[x]\^2}\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({x\^a, x\^a\ Log[x], x\^a\ Log[x]\^2}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(w = 
        Table[\[PartialD]\_{x, i}Ker, {i, 0, Length[Ker] - 1}];\)\)], "Input",\

  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[Det[w]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\ x\^\(\(-3\) + 3\ a\)\)], "Output"]
}, Closed]],

Cell[TextData["This is nonzero for x!=0."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Complex Roots"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[a, b]\), "\n", 
    \(Ker = x\^a\ {Cos[b\ Log[x]], Sin[b\ Log[x]]}\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({x\^a\ Cos[b\ Log[x]], x\^a\ Sin[b\ Log[x]]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      w = Table[\[PartialD]\_{x, i}Ker, {i, 0, Length[Ker] - 1}]]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(x\^a\ Cos[b\ Log[x]]\), \(x\^a\ Sin[b\ Log[x]]\)},
            {\(a\ x\^\(\(-1\) + a\)\ Cos[b\ Log[x]] - 
                b\ x\^\(\(-1\) + a\)\ Sin[
                    b\ Log[x]]\), \(b\ x\^\(\(-1\) + a\)\ Cos[b\ Log[x]] + 
                a\ x\^\(\(-1\) + a\)\ Sin[b\ Log[x]]\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[Det[w]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(b\ x\^\(\(-1\) + 2\ a\)\ \((Cos[b\ Log[x]]\^2 + 
          Sin[b\ Log[x]]\^2)\)\)], "Output"]
}, Closed]],

Cell[TextData["This is nonzero for x!=0 and b!=0."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{534, 369},
WindowMargins->{{71, Automatic}, {Automatic, 26}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 140, 3, 125, "Subtitle",
  Evaluatable->False],
Cell[1919, 58, 148, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2092, 66, 92, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2209, 72, 120, 3, 47, "Input"],
Cell[2332, 77, 52, 1, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2421, 83, 139, 4, 28, "Input"],
Cell[2563, 89, 505, 11, 77, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3105, 105, 74, 2, 27, "Input"],
Cell[3182, 109, 114, 2, 29, "Output"]
}, Closed]],
Cell[3311, 114, 132, 3, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[3480, 122, 92, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3597, 128, 121, 3, 47, "Input"],
Cell[3721, 133, 71, 1, 29, "Output"]
}, Closed]],
Cell[3807, 137, 134, 4, 28, "Input"],

Cell[CellGroupData[{
Cell[3966, 145, 74, 2, 27, "Input"],
Cell[4043, 149, 57, 1, 29, "Output"]
}, Closed]],
Cell[4115, 153, 100, 2, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[4252, 160, 91, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4368, 166, 134, 3, 43, "Input"],
Cell[4505, 171, 78, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4620, 177, 139, 4, 28, "Input"],
Cell[4762, 183, 476, 10, 57, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5275, 198, 74, 2, 27, "Input"],
Cell[5352, 202, 113, 2, 29, "Output"]
}, Closed]],
Cell[5480, 207, 109, 2, 32, "Text",
  Evaluatable->False]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

en  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
